/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import gen.core.filters.Filters;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.omegat.core.segmentation.SRX;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.FiltersUtil;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PreferencesImpl;
import org.omegat.util.PreferencesXML;
import org.omegat.util.StaticUtils;

public final class Preferences {
    public static final String FILE_PREFERENCES = "omegat" + OStrings.getBrandingToken() + ".prefs";
    public static final String SOURCE_LOCALE = "source_lang";
    public static final String TARGET_LOCALE = "target_lang";
    public static final String CURRENT_FOLDER = "current_folder";
    public static final String SOURCE_FOLDER = "source_folder";
    public static final String TARGET_FOLDER = "target_folder";
    public static final String TM_FOLDER = "tm_folder";
    public static final String DICT_FOLDER = "dict_folder";
    public static final String GLOSSARY_FOLDER = "glossary_folder";
    public static final String GLOSSARY_FILE = "glossary_file";
    public static final String TF_SRC_FONT_NAME = "source_font";
    public static final String TF_FONT_DEFAULT = "Dialog";
    public static final String TF_SRC_FONT_SIZE = "source_font_size";
    public static final int TF_FONT_SIZE_DEFAULT = 12;
    public static final String MT_AUTO_FETCH = "mt_auto_fetch";
    public static final String MT_ONLY_UNTRANSLATED = "mt_only_untranslated";
    public static final String GLOSSARY_TBX_DISPLAY_CONTEXT = "glossary_tbx_display_context";
    public static final boolean GLOSSARY_TBX_DISPLAY_CONTEXT_DEFAULT = true;
    public static final String GLOSSARY_NOT_EXACT_MATCH = "glossary_not_exact_match";
    public static final boolean GLOSSARY_NOT_EXACT_MATCH_DEFAULT = true;
    public static final String GLOSSARY_STEMMING = "glossary_stemming";
    public static final boolean GLOSSARY_STEMMING_DEFAULT = true;
    public static final String GLOSSARY_REPLACE_ON_INSERT = "glossary_replace_on_insert";
    public static final String GLOSSARY_REQUIRE_SIMILAR_CASE = "glossary_require_similar_case";
    public static final boolean GLOSSARY_REQUIRE_SIMILAR_CASE_DEFAULT = true;
    public static final String DICTIONARY_FUZZY_MATCHING = "dictionary_fuzzy_matching";
    public static final String DICTIONARY_AUTO_SEARCH = "dictionary_auto_search";
    public static final String MAINWINDOW_GEOMETRY_PREFIX = "screen";
    public static final String MAINWINDOW_LAYOUT = "docking_layout";
    public static final String PROJECT_FILES_WINDOW_GEOMETRY_PREFIX = "project_files_window";
    public static final String PROJECT_FILES_USE_FONT = "project_files_use_font";
    public static final String PROJECT_FILES_SHOW_ON_LOAD = "project_files_show_on_load";
    public static final String SEARCHWINDOW_GEOMETRY_PREFIX = "search_window";
    public static final String SEARCHWINDOW_SEARCH_TYPE = "search_window_search_type";
    public static final String SEARCHWINDOW_REPLACE_TYPE = "search_window_replace_type";
    public static final String SEARCHWINDOW_CASE_SENSITIVE = "search_window_case_sensitive";
    public static final String SEARCHWINDOW_SPACE_MATCH_NBSP = "search_window_space_match_nbsp";
    public static final String SEARCHWINDOW_CASE_SENSITIVE_REPLACE = "search_window_case_sensitive_replace";
    public static final String SEARCHWINDOW_SPACE_MATCH_NBSP_REPLACE = "search_window_space_match_nbsp_replace";
    public static final String SEARCHWINDOW_REPLACE_UNTRANSLATED = "search_window_replace_untranslated";
    public static final String SEARCHWINDOW_SEARCH_SOURCE = "search_window_search_source";
    public static final String SEARCHWINDOW_SEARCH_TRANSLATION = "search_window_search_translation";
    public static final String SEARCHWINDOW_SEARCH_STATE = "search_window_search_state";
    public static final String SEARCHWINDOW_SEARCH_NOTES = "search_window_search_notes";
    public static final String SEARCHWINDOW_SEARCH_COMMENTS = "search_window_search_comments";
    public static final String SEARCHWINDOW_REG_EXPRESSIONS = "search_window_reg_expressions";
    public static final String SEARCHWINDOW_GLOSSARY_SEARCH = "search_window_glossary_search";
    public static final String SEARCHWINDOW_MEMORY_SEARCH = "search_window_memory_search";
    public static final String SEARCHWINDOW_TM_SEARCH = "search_window_tm_search";
    public static final String SEARCHWINDOW_ALL_RESULTS = "search_window_all_results";
    public static final String SEARCHWINDOW_FILE_NAMES = "search_window_file_names";
    public static final String SEARCHWINDOW_ADVANCED_VISIBLE = "search_window_advanced_visible";
    public static final String SEARCHWINDOW_SEARCH_AUTHOR = "search_window_search_author";
    public static final String SEARCHWINDOW_AUTHOR_NAME = "search_window_author_name";
    public static final String SEARCHWINDOW_DATE_FROM = "search_window_date_from";
    public static final String SEARCHWINDOW_DATE_FROM_VALUE = "search_window_date_from_value";
    public static final String SEARCHWINDOW_DATE_TO = "search_window_date_to";
    public static final String SEARCHWINDOW_DATE_TO_VALUE = "search_window_date_to_value";
    public static final String SEARCHWINDOW_NUMBER_OF_RESULTS = "search_window_number_of_results";
    public static final String SEARCHWINDOW_DIR = "search_window_dir";
    public static final String SEARCHWINDOW_SEARCH_FILES = "search_window_search_files";
    public static final String SEARCHWINDOW_RECURSIVE = "search_window_search_recursive";
    public static final String SEARCHWINDOW_AUTO_SYNC = "search_window_auto_sync";
    public static final String SEARCHWINDOW_BACK_TO_INITIAL_SEGMENT = "search_window_back_to_initial_segment";
    public static final String SEARCHWINDOW_EXCLUDE_ORPHANS = "search_window_exclude_orphans";
    public static final String SEARCHWINDOW_FULLHALFWIDTH_INSENSITIVE = "search_window_full_half_width_insensitive";
    public static final String SEARCHWINDOW_HISTORY_SIZE = "search_window_history_size";
    public static final String SEARCHWINDOW_SEARCH_HISTORY_ITEM_PREFIX = "search_window_search_history_item_";
    public static final String SEARCHWINDOW_REPLACE_HISTORY_ITEM_PREFIX = "search_window_replace_history_item_";
    public static final String TAGVWINDOW_WIDTH = "tagv_window_width";
    public static final String TAGVWINDOW_HEIGHT = "tagv_window_height";
    public static final String TAGVWINDOW_X = "tagv_window_x";
    public static final String TAGVWINDOW_Y = "tagv_window_y";
    public static final String USE_TAB_TO_ADVANCE = "tab_advance";
    public static final String ALWAYS_CONFIRM_QUIT = "always_confirm_quit";
    public static final String ALLOW_GOOGLE_TRANSLATE = "allow_google_translate";
    public static final String ALLOW_GOOGLE2_TRANSLATE = "allow_google2_translate";
    public static final String ALLOW_BELAZAR_TRANSLATE = "allow_belazar_translate";
    public static final String ALLOW_DEEPL_TRANSLATE = "allow_deepl_translate";
    public static final String ALLOW_IBMWATSON_TRANSLATE = "allow_ibmwatson_translate";
    public static final String ALLOW_APERTIUM_TRANSLATE = "allow_apertium_translate";
    public static final String ALLOW_MICROSOFT_TRANSLATOR_AZURE = "allow_microsoft_translator_azure";
    public static final String ALLOW_MYMEMORY_HUMAN_TRANSLATE = "allow_mymemory_human_translate";
    public static final String ALLOW_MYMEMORY_MACHINE_TRANSLATE = "allow_mymemory_machine_translate";
    public static final String ALLOW_YANDEX_TRANSLATE = "allow_yandex_translate";
    public static final String ALLOW_YANDEX_CLOUD_TRANSLATE = "allow_yandex_cloud_translate";
    public static final String ALLOW_MOSES_TRANSLATE = "allow_moses_translate";
    public static final String MARK_GLOSSARY_MATCHES = "transtips";
    public static final String MARK_NOTED_SEGMENTS = "mark_noted_segments";
    public static final String MARK_NBSP = "mark_nbsp";
    public static final String MARK_WHITESPACE = "mark_whitespace";
    public static final String MARK_BIDI = "mark_bidi";
    public static final String FONT_FALLBACK = "font_fallback";
    public static final String MARK_PARA_DELIMITATIONS = "mark_para_delimitation";
    public static final String MARK_PARA_TEXT = "mark_para_delimitation_text";
    public static final String MARK_PARA_TEXT_DEFAULT = "\u2014 \u00b6 \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014";
    public static final String MARK_TRANSLATED_SEGMENTS = "mark_translated_segments";
    public static final String MARK_AUTOPOPULATED = "mark_autopopulated";
    public static final String MARK_UNTRANSLATED_SEGMENTS = "mark_untranslated_segments";
    public static final String DONT_INSERT_SOURCE_TEXT = "wf_noSourceText";
    public static final String ALLOW_TRANS_EQUAL_TO_SRC = "wf_allowTransEqualToSrc";
    public static final String BEST_MATCH_INSERT = "wf_insertBestMatch";
    public static final String BEST_MATCH_MINIMAL_SIMILARITY = "wf_minimalSimilarity";
    public static final int BEST_MATCH_MINIMAL_SIMILARITY_DEFAULT = 80;
    public static final String PENALTY_FOR_FOREIGN_MATCHES = "penalty_foreign_matches";
    public static final int PENALTY_FOR_FOREIGN_MATCHES_DEFAULT = 30;
    public static final String BEST_MATCH_EXPLANATORY_TEXT = "wf_explanatoryText";
    public static final String EXPORT_CURRENT_SEGMENT = "wf_exportCurrentSegment";
    public static final String STOP_ON_ALTERNATIVE_TRANSLATION = "wf_stopOnAlternativeTranslation";
    public static final String CONVERT_NUMBERS = "wf_convertNumbers";
    public static final String SAVE_AUTO_STATUS = "save_auto_status";
    public static final String EDITOR_INITIAL_SEGMENT_LOAD_COUNT = "editor_initial_segment_load_count";
    public static final int EDITOR_INITIAL_SEGMENT_LOAD_COUNT_DEFAULT = 2000;
    public static final String DONT_CHECK_PRINTF_TAGS = "tagValidation_noCheck";
    public static final boolean DONT_CHECK_PRINTF_TAGS_DEFAULT = true;
    public static final String CHECK_SIMPLE_PRINTF_TAGS = "tagValidation_simpleCheck";
    public static final String CHECK_ALL_PRINTF_TAGS = "tagValidation_elaborateCheck";
    public static final String CHECK_JAVA_PATTERN_TAGS = "tagValidation_javaMessageFormatSimplePatternCheck";
    public static final String CHECK_CUSTOM_PATTERN = "tagValidation_customPattern";
    public static final String CHECK_REMOVE_PATTERN = "tagValidation_removePattern";
    public static final String ALLOW_TAG_EDITING = "allowTagEditing";
    public static final String TAG_VALIDATE_ON_LEAVE = "tagValidateOnLeave";
    public static final String TEAM_AUTHOR = "team_Author";
    public static final String ALLOW_AUTO_SPELLCHECKING = "allow_auto_spellchecking";
    public static final String SPELLCHECKER_DICTIONARY_DIRECTORY = "spellcheker_dir";
    public static final String SPELLCHECKER_DICTIONARY_URL = "dictionary_url";
    public static final String LANGUAGETOOL_BRIDGE_TYPE = "lt_bridgeType";
    public static final String LANGUAGETOOL_REMOTE_URL = "lt_remoteURL";
    public static final String LANGUAGETOOL_LOCAL_SERVER_JAR_PATH = "lt_localServerJarPath";
    public static final String LANGUAGETOOL_DISABLED_CATEGORIES_PREFIX = "lt_disabledCategories";
    public static final String LANGUAGETOOL_DISABLED_RULES_PREFIX = "lt_disabledRules";
    public static final String LANGUAGETOOL_ENABLED_RULES_PREFIX = "lt_enabledRules";
    public static final String SCRIPTS_DIRECTORY = "scripts_dir";
    public static final String SCRIPTS_QUICK_PREFIX = "scripts_quick_";
    public static final String SCRIPTS_QUICK_1 = "scripts_quick_1";
    public static final String SCRIPTS_QUICK_2 = "scripts_quick_2";
    public static final String SCRIPTS_QUICK_3 = "scripts_quick_3";
    public static final String SCRIPTS_QUICK_4 = "scripts_quick_4";
    public static final String SCRIPTS_QUICK_5 = "scripts_quick_5";
    public static final String SCRIPTS_QUICK_6 = "scripts_quick_6";
    public static final String SCRIPTS_QUICK_7 = "scripts_quick_7";
    public static final String SCRIPTS_QUICK_8 = "scripts_quick_8";
    public static final String SCRIPTS_QUICK_9 = "scripts_quick_9";
    public static final String SCRIPTS_QUICK_0 = "scripts_quick_0";
    public static final String SCRIPTWINDOW_GEOMETRY_PREFIX = "script_window";
    public static final String MOST_RECENT_PROJECTS_SIZE = "most_recent_projects_size";
    public static final String MOST_RECENT_PROJECTS_PREFIX = "most_recent_projects_";
    public static final String DISPLAY_SEGMENT_SOURCES = "display_segment_sources";
    public static final String MARK_NON_UNIQUE_SEGMENTS = "mark_non_unique_segments";
    public static final String DISPLAY_MODIFICATION_INFO = "display_modification_info";
    public static final String EXT_TMX_SHOW_LEVEL2 = "ext_tmx_show_level2";
    public static final String EXT_TMX_USE_SLASH = "ext_tmx_use_slash";
    public static final String EXT_TMX_MATCH_TEMPLATE = "ext_tmx_match_template";
    public static final String EXT_TMX_SORT_KEY = "ext_tmx_sort_key";
    public static final String EXT_TMX_KEEP_FOREIGN_MATCH = "keep_foreign_matches";
    public static final String EXT_TMX_FUZZY_MATCH_THRESHOLD = "ext_tmx_fuzzy_match_threshold";
    public static final String VIEW_OPTION_SOURCE_ALL_BOLD = "view_option_source_all_bold";
    public static final boolean VIEW_OPTION_SOURCE_ALL_BOLD_DEFAULT = true;
    public static final String VIEW_OPTION_SOURCE_ACTIVE_BOLD = "view_option_source_active_bold";
    public static final boolean VIEW_OPTION_SOURCE_ACTIVE_BOLD_DEFAULT = true;
    public static final String VIEW_OPTION_UNIQUE_FIRST = "view_option_unique_first";
    public static final String VIEW_OPTION_PPT_SIMPLIFY = "view_option_ppt_simplify";
    public static final boolean VIEW_OPTION_PPT_SIMPLIFY_DEFAULT = true;
    public static final String VIEW_OPTION_TEMPLATE_ACTIVE = "view_option_template_active";
    public static final boolean VIEW_OPTION_TEMPLATE_ACTIVE_DEFAULT = true;
    public static final String VIEW_OPTION_MOD_INFO_TEMPLATE = "view_option_mod_info_template";
    public static final String VIEW_OPTION_MOD_INFO_TEMPLATE_WO_DATE = "view_option_mod_info_template_wo_date";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String AUTO_SAVE_INTERVAL = "auto_save_interval";
    public static final int AUTO_SAVE_DEFAULT = 180;
    public static final String EXTERNAL_COMMAND = "external_command";
    public static final String ALLOW_PROJECT_EXTERN_CMD = "allow_project_extern_cmd";
    public static final String FILTERS_VERSION = "filters_version";
    public static final String LT_DISABLED = "lt_disabled";
    public static final boolean LT_DISABLED_DEFAULT = true;
    public static final String LOOSE_TAG_ORDERING = "loose_tag_ordering";
    public static final String TAGS_VALID_REQUIRED = "tags_valid_required";
    public static final String STAT_COUNTING_PROTECTED_TEXT = "stat_counting_protected_text";
    public static final boolean STAT_COUNTING_PROTECTED_TEXT_DEFAULT = true;
    public static final String STAT_COUNTING_CUSTOM_TAGS = "stat_counting_custom_tags";
    public static final boolean STAT_COUNTING_CUSTOM_TAGS_DEFAULT = true;
    public static final String TOK_BEHAVIOR_PREFIX = "tokenizer_behavior_";
    public static final String AC_SHOW_SUGGESTIONS_AUTOMATICALLY = "ac_show_suggestions_automatically";
    public static final String AC_SWITCH_VIEWS_WITH_LR = "ac_switch_views_with_lr";
    public static final String AC_GLOSSARY_ENABLED = "ac_glossary_enabled";
    public static final boolean AC_GLOSSARY_ENABLED_DEFAULT = true;
    public static final String AC_GLOSSARY_SHOW_SOURCE = "ac_glossary_show_source";
    public static final String AC_GLOSSARY_SHOW_TARGET_BEFORE_SOURCE = "ac_glossary_show_target_before_source";
    public static final String AC_GLOSSARY_SORT_BY_SOURCE = "ac_glossary_sort_by_source";
    public static final String AC_GLOSSARY_SORT_BY_LENGTH = "ac_glossary_sort_by_length";
    public static final String AC_GLOSSARY_SORT_ALPHABETICALLY = "ac_glossary_sort_alphabetically";
    public static final String AC_GLOSSARY_CAPITALIZE = "ac_glossary_capitalize";
    public static final String AC_AUTOTEXT_ENABLED = "ac_autotext_enabled";
    public static final boolean AC_AUTOTEXT_ENABLED_DEFAULT = true;
    public static final String AC_AUTOTEXT_SORT_BY_LENGTH = "ac_autotext_sort_by_length";
    public static final String AC_AUTOTEXT_SORT_ALPHABETICALLY = "ac_autotext_sort_alphabetically";
    public static final String AC_AUTOTEXT_SORT_FULL_TEXT = "ac_autotext_sort_full_text";
    public static final String AC_CHARTABLE_ENABLED = "ac_chartable_enabled";
    public static final boolean AC_CHARTABLE_ENABLED_DEFAULT = true;
    public static final String AC_CHARTABLE_USE_CUSTOM_CHARS = "ac_chartable_use_custom_chars";
    public static final String AC_CHARTABLE_CUSTOM_CHAR_STRING = "ac_chartable_custom_char_string";
    public static final String AC_CHARTABLE_UNIQUE_CUSTOM_CHARS = "ac_chartable_unique_custom_chars";
    public static final String AC_HISTORY_COMPLETION_ENABLED = "allow_history_completer";
    public static final String AC_HISTORY_PREDICTION_ENABLED = "history_completer_prediction_enabled";
    public static final String SB_PROGRESS_MODE = "sb_progress_mode";
    public static final String TAAS_LOOKUP = "taas_lookup";
    public static final String TAAS_DOMAIN = "taas_domain";
    public static final String SEGPROPS_INITIAL_MODE = "segment_properties_initial_mode";
    public static final String SEGPROPS_SHOW_RAW_KEYS = "segment_properties_show_raw_keys";
    public static final String SEGPROPS_NOTIFY_PROPS = "segment_properties_notify_props";
    public static final String SEGPROPS_NOTIFY_DEFAULT_PROPS = "comment, note";
    public static final String NOTIFY_FUZZY_MATCHES = "notify_fuzzy_matches";
    public static final String NOTIFY_GLOSSARY_HITS = "notify_glossary_hits";
    public static final String NOTIFY_COMMENTS = "notify_comments";
    public static final String NOTIFY_DICTIONARY_HITS = "notify_dictionary_hits";
    public static final String NOTIFY_MULTIPLE_TRANSLATIONS = "notify_multiple_translations";
    public static final String NOTIFY_NOTES = "notify_notes";
    public static final String ALIGNER_HIGHLIGHT_PATTERN = "aligner_highlight_pattern";
    public static final String ALIGNER_HIGHLIGHT_PATTERN_DEFAULT = "\\d+";
    public static final String CREATE_GLOSSARY_GEOMETRY_PREFIX = "create_glossary_dialog";
    public static final String PROPERTY_SRX = "srx";
    public static final String PROPERTY_FILTERS = "filters";
    public static final String STATISTICS_WINDOW_GEOMETRY_PREFIX = "stat_window";
    public static final String ISSUES_WINDOW_GEOMETRY_PREFIX = "issues_window";
    public static final String ISSUES_WINDOW_DIVIDER_LOCATION_BOTTOM = "issues_window_divider_location_bottom";
    public static final String ISSUE_PROVIDERS_DISABLED = "issue_providers_disabled";
    public static final String ISSUE_PROVIDERS_DONT_ASK = "issue_providers_dont_ask";
    public static final String EXTERNAL_FINDER_ALLOW_PROJECT_COMMANDS = "external_finder_allow_project_commands";
    public static final String VERSION_CHECK_AUTOMATIC = "automatically_check_version";
    public static final boolean VERSION_CHECK_AUTOMATIC_DEFAULT = true;
    private static volatile boolean didInit = false;
    private static IPreferences preferences;
    private static volatile boolean didInitSegmentation;
    private static SRX srx;
    private static volatile boolean didInitFilters;
    private static Filters filters;
    private static final PropertyChangeSupport PROP_CHANGE_SUPPORT;

    private Preferences() {
    }

    public static String getPreference(String key) {
        return preferences.getPreference(key);
    }

    public static boolean existsPreference(String key) {
        return preferences.existsPreference(key);
    }

    public static boolean isPreference(String key) {
        return preferences.isPreference(key);
    }

    public static boolean isPreferenceDefault(String key, boolean defaultValue) {
        return preferences.isPreferenceDefault(key, defaultValue);
    }

    public static String getPreferenceDefault(String key, String defaultValue) {
        return preferences.getPreferenceDefault(key, defaultValue);
    }

    public static <T extends Enum<T>> T getPreferenceEnumDefault(String key, T defaultValue) {
        return preferences.getPreferenceEnumDefault(key, defaultValue);
    }

    public static int getPreferenceDefault(String key, int defaultValue) {
        return preferences.getPreferenceDefault(key, defaultValue);
    }

    public static void setPreference(String name, Object value) {
        String storedNewValue;
        Object oldValue = preferences.setPreference(name, value);
        if (!Objects.equals(oldValue, storedNewValue = preferences.getPreference(name))) {
            PROP_CHANGE_SUPPORT.firePropertyChange(name, oldValue, value);
        }
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        PROP_CHANGE_SUPPORT.addPropertyChangeListener(listener);
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        PROP_CHANGE_SUPPORT.addPropertyChangeListener(property, listener);
    }

    public static void setFilters(Filters newFilters) {
        Filters oldValue = filters;
        filters = newFilters;
        File filtersFile = new File(StaticUtils.getConfigDir(), "filters.xml");
        try {
            FilterMaster.saveConfig(filters, filtersFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (!FiltersUtil.filtersEqual(oldValue, newFilters)) {
            PROP_CHANGE_SUPPORT.firePropertyChange(PROPERTY_FILTERS, oldValue, newFilters);
        }
    }

    public static Filters getFilters() {
        return filters;
    }

    public static void setSRX(SRX newSrx) {
        SRX oldValue = srx;
        srx = newSrx;
        File srxFile = new File(StaticUtils.getConfigDir() + "segmentation.conf");
        try {
            SRX.saveTo(srx, srxFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PROP_CHANGE_SUPPORT.firePropertyChange(PROPERTY_SRX, oldValue, newSrx);
    }

    public static SRX getSRX() {
        return srx;
    }

    public static void save() {
        preferences.save();
    }

    public static synchronized void init() {
        if (didInit) {
            return;
        }
        didInit = true;
        File loadFile = Preferences.getPreferencesFile();
        File saveFile = new File(StaticUtils.getConfigDir(), FILE_PREFERENCES);
        preferences = new PreferencesImpl(new PreferencesXML(loadFile, saveFile));
    }

    public static synchronized void initFilters() {
        if (didInitFilters) {
            return;
        }
        didInitFilters = true;
        File filtersFile = new File(StaticUtils.getConfigDir(), "filters.xml");
        Filters f = null;
        try {
            f = FilterMaster.loadConfig(filtersFile);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
        if (f == null) {
            f = FilterMaster.createDefaultFiltersConfig();
        }
        filters = f;
    }

    public static synchronized void initSegmentation() {
        if (didInitSegmentation) {
            return;
        }
        didInitSegmentation = true;
        File srxFile = new File(StaticUtils.getConfigDir(), "segmentation.conf");
        SRX s = SRX.loadSRX(srxFile);
        if (s == null) {
            s = SRX.getDefault();
        }
        srx = s;
    }

    private static File getPreferencesFile() {
        File prefsFile = new File(StaticUtils.getConfigDir(), FILE_PREFERENCES);
        if (prefsFile.exists()) {
            return prefsFile;
        }
        prefsFile = new File(StaticUtils.installDir(), FILE_PREFERENCES);
        if (prefsFile.exists()) {
            return prefsFile;
        }
        return null;
    }

    static {
        didInitSegmentation = false;
        didInitFilters = false;
        PROP_CHANGE_SUPPORT = new PropertyChangeSupport(Preferences.class);
    }

    public static interface IPreferences {
        public String getPreference(String var1);

        public boolean existsPreference(String var1);

        public boolean isPreference(String var1);

        public boolean isPreferenceDefault(String var1, boolean var2);

        public String getPreferenceDefault(String var1, String var2);

        public <T extends Enum<T>> T getPreferenceEnumDefault(String var1, T var2);

        public int getPreferenceDefault(String var1, int var2);

        public Object setPreference(String var1, Object var2);

        public void save();
    }
}

